
<!doctype html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{$portal->name}} LICITAÇAO DETALHES</title>


    <!-- Facebook -->
    <meta property="og:title" content="{{$portal->name}} LICITAÇÕES">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{asset($portal->imglogo)}}">


    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{$portal->name}} LICITAÇÕES">
    <meta name="twitter:image" content="{{asset($portal->imglogo)}}">

    <link rel="shortcut icon" href="http://www.itapemirim.es.leg.br/assets/img/favicon.png">
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/bootstrap.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/bootflat.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/font-awesome.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/fonts.css?v=1.1" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/validationEngine.jquery.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/style.css" type="text/css" />
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/style_controladoria.css?v=2.1" type="text/css">

    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <link href="css/ie10-viewport-bug-workaround.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/html5shiv.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/respond.min.js"></script>
    <![endif]-->

    <!-- Bootstrap -->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery-1.11.1.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/bootstrap.min.js"></script>
    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/ie10-viewport-bug-workaround.js"></script>

    <!-- Bootflat's JS files.-->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fs.selecter.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/icheck.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fs.stepper.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.mask.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.maxlength.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/scripts.js?v=2.2"></script>

    <script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.flexisel.js"></script>

    <script type="text/javascript" src="https://www.google.com/jsapi"></script>
    <script>google.load("visualization", "1.1", {packages:["corechart","bar"]});</script>
    <style>
        .pagination .active {
            background-color: {{$portal->headercor}} !important;
        }
    </style>
</head>
<body style="background-color:#fafafa;">




<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 paginatransparencia ajustar_fonte" id="pagina">



        <div class="panel panel-primary">
            <div class="panel-heading" style=" background-color: {{$portal->headercor}};">
                <h3 class="panel-title" style="text-transform:uppercase;"> <i class="fa fa-file-text-o"></i>
                    @if($licitacao->categorias == 1 )Adesão à Registro de Preços @endif
                    @if($licitacao->categorias == 2 ) Carta Convite @endif
                    @if($licitacao->categorias == 3 ) Chamada Pública @endif
                    @if($licitacao->categorias == 4 ) Concurso @endif
                    @if($licitacao->categorias == 5 ) Dispensa @endif
                    @if($licitacao->categorias == 6 ) Inegibilidade @endif
                    @if($licitacao->categorias == 7 ) Leilão @endif
                    @if($licitacao->categorias == 8 ) Pregão Eletrônico @endif
                    @if($licitacao->categorias == 9 ) Pregão Presencial @endif
                    @if($licitacao->categorias == 10 ) Tomada de Preço @endif



                    nº {{$licitacao->numero}}
                </h3>
            </div>

            <div class="panel-body">


                <div role="tabpanel">

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation">&nbsp;&nbsp;&nbsp;</li>
                        <li role="presentation" @if($posi == 'detalhes') class="active" @endif><a href="#detalhes" aria-controls="detalhes" role="tab" data-toggle="tab"><i class="fa fa-gavel"></i> DETALHES DA LICITAÇÃO</a></li>

                        <li role="presentation" @if($posi == 'anexos') class="active" @endif ><a href="#anexos" aria-controls="anexos" role="tab" data-toggle="tab"><i class="fa fa-paperclip"></i> DOCUMENTOS</a></li>

                        <li role="presentation" @if($posi == 'etapas') class="active" @endif ><a href="#etapas" aria-controls="etapas" role="tab" data-toggle="tab"><i class="fa fa-file-text-o"></i> ETAPAS</a></li>
                        @if($licitacao->empresavencer != '')
                        <li role="presentation" ><a  @if($posi == 'vencedor') class="active" @endif href="#vencedores" aria-controls="vencedores" role="tab" data-toggle="tab"><i class="fa fa-trophy"></i> EMPRESA(S) VENCEDORA(S)</a></li>
@endif
                        <li role="presentation" @if($posi == 'acompanhamento') class="active" @endif><a href="#acompanhamento" aria-controls="acompanhamento" role="tab" data-toggle="tab"><i class="fa fa-envelope"></i> ACOMPANHAMENTO</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content" style="padding-left:0;padding-right:0;">
                        <div role="tabpanel" class="tab-pane @if($posi == 'acompanhamento') active @endif" id="acompanhamento" style="min-height:300px">
                            <h4>Cadastre-se aqui e receba comunicados sobre esta licitação</h4>
                            {!! Form::open(['url'=>routeTenant('site.licitacao.acompanhar'),'class'=>'']) !!}

                            <div class="row">
                                    <div class="form-group col-lg-6">
                                        <label for="nome" class="control-label">Nome / Razão Social *</label>
                                        <input type="text" class="form-control validate[required]" name="nome" maxlength="100" required>
                                        <input type="hidden" name="licitacao_id" value="{{$licitacao->id}}">

                                    </div>

                                    <div class="form-group col-lg-3">
                                        <label for="cpf" class="control-label">CPF / CNPJ (Só números)*</label>
                                        <input type="text" class="form-control validate[required] cpf" name="cpf" required>
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label for="telefone" class="control-label">Telefone</label>
                                        <input type="text" class="form-control tel" name="telefone" maxlength="100" required>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <label for="email" class="control-label">E-mail *</label>
                                        <input type="email" class="form-control  validate[required,custom[email]]" name="email" maxlength="100" required>
                                    </div>

                                </div>

                                <!-- BOTÕES (ações) -->
                                <div class="row col-lg-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-check-circle"></i> Cadastrar
                                    </button>
                                </div>
                                <!-- /BOTÕES -->

                            </form>      <!-- /FORMULARIO -->
                        </div><!-- acompanhamento -->


@if($licitacao->empresavencer != '')
                        <div @if($posi == 'vencedor') active @endif role="tabpanel" class="tab-pane " id="vencedores" style="min-height:300px">
                            <table class="table table-bordered tabelalicitacao">
                                <tbody>
                                <tr>
                                    <td valign="top" class="tdcinza" width="20%">Empresa(s) Vencedora(s):</td>
                                    <td colspan="5"> {{$licitacao->empresavencer}}<br />
                                        CNPJ Nº {{$licitacao->empresavencer_cnpj	}} </td>
                                </tr>
                                </tbody>
                            </table>
                        </div><!-- vencedores -->


@endif

                        <div role="tabpanel" class="tab-pane @if($posi == 'detalhes') active @endif" id="detalhes" style="min-height:300px">
                            @if($errors->any())
                                <h5 style="color: #00ab6c; text-align: center;">{{$errors->first()}}</h5>
                            @endif
                            <table class="table table-bordered tabelalicitacao">
                                <tbody>
                                <tr>
                                    <td valign="top" class="tdcinza" width="20%">Objeto:</td>
                                    <td colspan="5"> {{$licitacao->objeto}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Modalidade:</td>
                                    <td>
                                        @if($licitacao->categorias == 1 )Adesão à Registro de Preços @endif
                                        @if($licitacao->categorias == 2 ) Carta Convite @endif
                                        @if($licitacao->categorias == 3 ) Chamada Pública @endif
                                        @if($licitacao->categorias == 4 ) Concurso @endif
                                        @if($licitacao->categorias == 5 ) Dispensa @endif
                                        @if($licitacao->categorias == 6 ) Inegibilidade @endif
                                        @if($licitacao->categorias == 7 ) Leilão @endif
                                        @if($licitacao->categorias == 8 ) Pregão Eletrônico @endif
                                        @if($licitacao->categorias == 9 ) Pregão Presencial @endif
                                        @if($licitacao->categorias == 10 ) Tomada de Preço @endif</td>
                                </tr>
                                <tr>
                                    <td valign="top" class="tdcinza">Status:</td>
                                    <td colspan="5"> {{$licitacao->status}} </td>
                                </tr>
                                <tr>
                                    <td valign="top" class="tdcinza">Data de Publicação:</td>
                                    <td colspan="5"> {{$licitacao->datapublicar->format('d/m/Y')}}</td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Data da Abertura:</td>
                                    <td>  {{$licitacao->data->format('d/m/Y - H:i')}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">N&deg; do Processo:</td>
                                    <td>{{$licitacao->numero}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Local da Licitação:</td>
                                    <td> {{$licitacao->account->name}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Telefone:</td>
                                    <td> {{$licitacao->account->telefone}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">E-mail:</td>
                                    <td> {{$licitacao->account->emaillicitacao}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Responsável:</td>
                                    <td> {{$licitacao->user->name}} </td>
                                </tr>


                                </tbody>
                            </table>
                        </div><!-- detalhes -->



                        <div role="tabpanel" class="tab-pane @if($posi == 'etapas') active @endif " id="etapas" style="min-height:300px">

                            <br>

                            <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'1'])}}" class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i> Publicação</a>


                            @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',2)->count() >= 1)
                            <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'2'])}}"
                               class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                Recurso Edital
                            </a>

                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',3)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'3'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Resposta do Recurso
                                    </a>
                                @endif

                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',4)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'4'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Ata de Jugamento
                                    </a>
                                @endif

                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',5)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'5'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Edital Retificado
                                    </a>
                                @endif


                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',5)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'5'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Edital Retificado
                                    </a>
                                @endif

                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',6)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'6'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Republicação Edital
                                    </a>
                                @endif
                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',7)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'7'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Recurso Jugamento
                                    </a>
                                @endif
                                @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',8)->count() >= 1)
                                    <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'8'])}}"
                                       class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                        Contra Recurso
                                    </a>
                                @endif
                            @endif

                            @if(App\LicitacaoDocumento::where('licitacao_id',$licitacao->id)->where('nome',9)->count() >= 1)
                                <a href="{{routeTenant('site.licitacao.etapa',[$licitacao->id,'9'])}}"
                                   class="btn btn-lg btn-primary popup"><i class="fa fa-check"></i>
                                    Adjudicação/Homologação
                                </a>
                            @endif
                        </div><!-- etapas -->







                        <div role="tabpanel" class="tab-pane @if($posi == 'anexos') active @endif  " id="anexos" style="min-height:300px">

                            <table class="table table-hover table-striped table-condensed table-bordered table-anexos" style="margin:0;">
                                <tbody>
                                @foreach($documetos as $documento)
                                    @if($documento->cadastro == 1)
                                <tr>
                                    <td> <a href="{{routeTenant('site.licitacao.acompanhamento',[$documento->id])}}" class="" target="_blank">


                                            @if($documento->nome == 1)   PUBLICAÇÃO @endif
                                            @if($documento->nome == 2)     RECURSO EDITAL @endif
                                            @if($documento->nome == 3)    RESPOSTA DO RECURSO @endif
                                            @if($documento->nome == 4)   ATA DE JUGAMENTO @endif
                                            @if($documento->nome == 5)    EDITAL RETIFICADO @endif
                                            @if($documento->nome  == 6)    REPUBLICAÇÂO EDITAL  @endif

                                            @if($documento->nome == 7)    RECURSO JUGAMANTO  @endif
                                            @if($documento->nome == 8)    CONTRA RECURSO  @endif
                                            @if($documento->nome == 9)    ADJUDICAÇÃO/HOMOLOGAÇÃO @endif
                                            @if($documento->nome == 10)   EDITAL DE LICITAÇÃO   @endif
                                            @if($documento->nome == 11)     RETIFICAÇÃO DO EDITAL    @endif
                                            @if($documento->nome == 12)    ANEXOS DO EDITAL  @endif
                                            @if($documento->nome == 13)  ESCLARECIMENTOS   @endif
                                            @if($documento->nome == 14)  IMPUGNAÇÃO DO EDITAL   @endif
                                            @if($documento->nome == 15) PARECER SOBRE IMPUGNAÇÃO   @endif
                                            @if($documento->nome == 16) ARQUIVO DE PROPOSTA   @endif
                                            @if($documento->nome == 17) OUTROS   @endif






                                        </a> </td>
                                    <td width="140">

                                        <a target="_blank" href="{{routeTenant('site.licitacao.acompanhamento',[$documento->id])}}"
                                           class="btn btn-sm btn-info "><i class="fa  fa-search"></i> VISUALIZAR</a>




                                    </td>
                                </tr>
                                    @else
                                        <tr>
                                            <td> <a href="{{url($documento->documento)}}" target="_blank">


                                                    @if($documento->nome == 1)   PUBLICAÇÃO @endif
                                                    @if($documento->nome == 2)     RECURSO EDITAL @endif
                                                    @if($documento->nome == 3)    RESPOSTA DO RECURSO @endif
                                                    @if($documento->nome == 4)   ATA DE JUGAMENTO @endif
                                                    @if($documento->nome == 5)    EDITAL RETIFICADO @endif
                                                    @if($documento->nome  == 6)    REPUBLICAÇÂO EDITAL  @endif

                                                    @if($documento->nome == 7)    RECURSO JUGAMANTO  @endif
                                                    @if($documento->nome == 8)    CONTRA RECURSO  @endif
                                                    @if($documento->nome == 9)    ADJUDICAÇÃO/HOMOLOGAÇÃO @endif
                                                    @if($documento->nome == 10)   EDITAL DE LICITAÇÃO   @endif
                                                    @if($documento->nome == 11)     RETIFICAÇÃO DO EDITAL    @endif
                                                    @if($documento->nome == 12)    ANEXOS DO EDITAL  @endif
                                                    @if($documento->nome == 13)  ESCLARECIMENTOS   @endif
                                                    @if($documento->nome == 14)  IMPUGNAÇÃO DO EDITAL   @endif
                                                    @if($documento->nome == 15) PARECER SOBRE IMPUGNAÇÃO   @endif
                                                    @if($documento->nome == 16) ARQUIVO DE PROPOSTA   @endif
                                                        @if($documento->nome == 17) OUTROS   @endif




                                                </a> </td>
                                            <td width="140"> <a href="{{url($documento->documento)}}" target="_blank" class="btn btn-sm btn-info" title="Download"><i class="fa fa-search"></i> VISUALIZAR</a> </td>
                                        </tr>
                                    @endif
                                @endforeach


                                </tbody>
                            </table>

                        </div><!-- anexos -->








                    </div>

                </div>


            </div>


        </div><!-- /panel -->



        <div vw class="enabled">
            <div vw-access-button class="active"></div>
            <div vw-plugin-wrapper>
                <div class="vw-plugin-top-wrapper"></div>
            </div>
        </div>
        <script src="https://vlibras.gov.br/app/vlibras-plugin.js"></script>
        <script>
            new window.VLibras.Widget('https://vlibras.gov.br/app');
        </script>



<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.validationEngine-pt_BR.min.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.validationEngine.min.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/other-validations.js"></script>
<script type="text/javascript">
    $(function(){
        $('.validation').validationEngine({autoHidePrompt:true,promptPosition:"topLeft",scroll:false});
    });

    $(window).load(function() {
        $("#flexiselSlide").flexisel({visibleItems:6,clone:true,pauseOnHover:true,autoPlay:true,animationSpeed:200,autoPlaySpeed: 3000});
    });
</script>



<script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fancybox.js"></script>
<link href="{{url('')}}/templates/prefeitura1/licitacao/css/jquery.fancybox.css" rel="stylesheet">
<script type="text/javascript">
    $(function(){
        $('.fancybox').fancybox();
        $(".popup").fancybox({'width':'95%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});

        $(".open_modal_large").fancybox({'width':'98%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});
        $(".open_modal_small").fancybox({'width':'50%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});

        $('#news_icon').hover(function(){
            $(this).stop(true,true).animate({'right':'0px'}, 'fast');
        }, function(){
            $(this).stop(true,true).animate({'right':'-130px'}, 'fast');
        });


        $('#btn_mobile').on('click', function(){
            $('#menubar, .asidebar, #top-menubar').stop(true,true).slideToggle();
        });
    });


</script>



<link href="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.smartmenus.bootstrap.css" rel="stylesheet">
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.smartmenus.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.smartmenus.bootstrap.js"></script>

</body>
</html>
