
<!doctype html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{$portal->name}} Ouvidoria</title>


    <!-- Facebook -->
    <meta property="og:title" content="{{$portal->name}} LICITAÇÕES">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{asset($portal->imglogo)}}">


    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{$portal->name}} LICITAÇÕES">
    <meta name="twitter:image" content="{{asset($portal->imglogo)}}">

    <link rel="shortcut icon" href="{{asset($portal->favicon)}}">
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/bootstrap.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/bootflat.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/font-awesome.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/validationEngine.jquery.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/style.css" type="text/css" />
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/style_controladoria.css?v=2.1" type="text/css">


    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/html5shiv.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/respond.min.js"></script>
    <![endif]-->

    <!-- Bootstrap -->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery-1.11.1.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/bootstrap.min.js"></script>
    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/ie10-viewport-bug-workaround.js"></script>

    <!-- Bootflat's JS files.-->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fs.selecter.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/icheck.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fs.stepper.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.mask.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.maxlength.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/scripts.js?v=2.2"></script>

    <script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.flexisel.js"></script>

    <script type="text/javascript" src="https://www.google.com/jsapi"></script>
    <script>google.load("visualization", "1.1", {packages:["corechart","bar"]});</script>
    <style>
        .pagination .active {
            background-color: {{$portal->headercor}} !important;
        }
        .sobrepodicao:hover {
            -webkit-transform: scale(1.2);
            -ms-transform: scale(1.2);
            transform: scale(1.2);
            z-index: 5;
        }
    </style>
</head>
<body style="background-color:#fafafa;">


<ul class="skiplist">
    <li class="skip"><a href="#conteudo" accesskey="2">Ir para o conteúdo</a></li>
</ul>



<div id="menutpdesktop" class="menu100 tp-processos" style="background-color: {{$portal->headercor}};">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">

                <a href="{{url('')}}/licitacoes"  style="float: left; padding: 10px;" >
                    <img height="45px" src=" @if($portal->logoborda ==  '0'){{asset($portal->imglogo)}} @else {{asset($portal->logoborda)}}  @endif "
                         alt="{{$portal->name}} LICITAÇÕES">
                </a>

                <div class="text" style="min-height: 45px; margin-top: 12px; margin-left: 20px; border-left: 2px solid #FFF;">
                    <div style="font-size: 22px; font-weight: normal; margin-top: 5px; margin-left: 20px; color: #FFF; "><strong>{{$portal->name}} </strong></div>
                </div>


            </div>
            <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                <div class="btns-acessibilidade" style="margin-top: 25px;">
                    <a style="background-color: {{$portal->headercor}};  "  href="{{url('')}}" accesskey="1" data-toggle="tooltip" data-placement="bottom" data-container="body" title="Página inicial" class="btn btn-xs"> <i class="fa fa-home" style="margin:0 3px;"> </i></a>

                    <button style="background-color: {{$portal->headercor}};  " type="button" id="acessibilidade_aumentarfonte" accesskey="3" data-toggle="tooltip" data-placement="bottom" data-container="body" title="Aumentar tamanho da fonte" class="btn btn-xs"><i class="fa fa-font"></i><i class="fa fa-plus" style="margin-left:-3px;"></i></button>
                    <button style="background-color: {{$portal->headercor}};  "  type="button" id="acessibilidade_diminuirfonte" accesskey="4" data-toggle="tooltip" data-placement="bottom" data-container="body" title="Diminuir tamanho da fonte" class="btn btn-xs"><i class="fa fa-font"></i><i class="fa fa-minus" style="margin-left:-5px;"></i></button>
                    <button  style="background-color: {{$portal->headercor}};  " type="button" id="acessibilidade_contraste" accesskey="5" data-toggle="tooltip" data-placement="bottom" data-container="body" title="Aplicar auto contraste" class="btn btn-xs" ><i class="fa fa-adjust"></i></button>
                    <!-- <a href="" accesskey="7" title="Mapa do site" class="btn btn-xs"><i class="fa fa-sitemap"></i></a> -->
                    <a style="background-color: {{$portal->headercor}};  "  href="{{url('')}}/webmail" accesskey="8" data-toggle="tooltip" data-placement="bottom" data-container="body" title="Área restrita - Webmail" class="btn btn-xs" target="_blank"><i class="fa fa-envelope"></i></a>
                    <!-- <a href="http://www.itapemirim.es.leg.br/sistema" accesskey="9" data-toggle="tooltip" data-placement="bottom" data-container="body" title="Área restrita - Intranet" class="btn btn-xs" target="_blank"> <i class="fa fa-lock" style="margin:0 3px;"> </i></a> -->
                </div>
            </div>
        </div>
    </div>
</div><!-- #menutpdesktop -->


<div id="menutpmobile" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
    <!-- Fixed navbar -->
    <nav id="navbarmobile" style="background-color:{{$portal->headercor}}; " class="navbar navbar-inverse navbar-fixed-top">
        <div class="container">
            <div class="navbar-header">

                <a href="{{url('')}}/licitacoes" style="height:auto;padding:5px 15px;" class="navbar-brand" title="CÂMARA MUNICIPAL DE ITAPEMIRIM - ES - PORTAL DA TRANSPARÊNCIA">
                    <img height="45px" src="@if($portal->logoborda ==  '0'){{asset($portal->imglogo)}} @else {{asset($portal->logoborda)}}  @endif"
                         alt="{{$portal->name}} LICITAÇÕES">                </a>
                <div class="text" style="min-height: 45px; ">
                    <div style="font-size: 16px;margin-top: 23px; text-align: center; margin-left: 20px; color: #FFF; "><strong>{{$portal->name}} </strong></div>
                </div>
            </div>
            <div id="navbar" class="navbar-collapse collapse">


            </div><!--/.nav-collapse -->
        </div>
    </nav>
</div><!-- menutpmobile -->


<script type="text/javascript">
    $(function(){
        $('.menu100-submenu,.menu100-submenu2,.menu100-submenu3').hover(function(){
            $(this).children('ul').stop(true,true).fadeIn();
            $(this).children('a').addClass('active');
        }, function(){
            $(this).children('ul').hide();
            $(this).children('a').removeClass('active');
        });
    });
</script>



<div class="container">
    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 paginatransparencia ajustar_fonte" id="pagina" >

            <div class="panel panel-primary" >
                <div class="panel-heading" style="background-color: #2ea10b;">
                    <h3 class="panel-title lh30 pull-left"> <i class="fa fa-lg fa-edit"></i> &nbsp; OUVIDORIA</h3>


                    {!! Form::open(['url'=>routeTenant('site.ouvidoria.consulta'),'class'=>'form-inline pull-right']) !!}



                    <div class="form-group">
                        <label class="sr-only" for="titulo">Busca</label>
                        <input type="text" class="form-control input-sm" id="titulo"
                               @if(isset($dataform['buscar']))   value="{{$dataform['buscar']}}" @endif
                               name="buscar" placeholder="Digite o Protocolo" value="">
                    </div>
                    <button type="submit" class="btn btn-sm btn-warning"><i class="fa fa-search"></i> Consultar</button>
                    <a href="{{url('')}}/ouvidoria" title="Limpar busca" class="btn btn-xs btn-default"><i class="fa fa-remove"></i></a>

                    &nbsp; &nbsp; <a class="btn btn-xs btn-default" title="Voltar para o início" href="{{url('')}}"><i class="fa fa-home"></i></a>
                    {!! Form::close() !!}
                    <div style="clear:both"></div>
                </div>





            </div><!-- /panel -->

            <div class="panel-body">
               @if ($ouvidorias == null)
                   <h4 style="text-align: center;"> Desculpe, mais não encotramos esse protocolo, por favor digite um protocolo valído </h4>
                   @else
                    <div class="panel ">
                        <table class="table table-bordered table-condensed tabelalicitacao">
                            <tbody>
                            <tr>
                                <td colspan="4" class="tdpreto" style="background-color:#878787;">
                                    Tipo:   @if($ouvidorias->tipo == 'de') Denúncia @endif
                                    @if($ouvidorias->tipo == 're') Reclamação @endif
                                    @if($ouvidorias->tipo == 'so') Solicitação @endif
                                    @if($ouvidorias->tipo == 'su') Sugestão @endif
                                    @if($ouvidorias->tipo == 'el') Elogio @endif
                                    @if($ouvidorias->tipo == 'si') Simplifique @endif



                                </td>
                            </tr>
                            <tr>
                                <td valign="top" class="tdcinza" width="15%">Depatarmento:</td>
                                <td colspan="3">   {{$ouvidorias->departamentos}}</td>
                            </tr>
                            <tr>
                                <td valign="top" class="tdcinza" width="15%">Protocolo:</td>
                                <td colspan="3">    {{$ouvidorias->protocolo}}</td>
                            </tr>
                            <tr>
                                <td class="tdcinza">Data Criação:</td>
                                <td>     {{$ouvidorias->created_at->format('d/m/Y H:i:s')}}

                                </td>
                                <td class="tdcinza" width="30%">Data da ultima Atualização:</td>
                                <td width="20%">  {{$ouvidorias->updated_at->format('d/m/Y H:i:s')}} </td>
                            </tr>
                            <tr>
                                <td valign="top" class="tdcinza" width="15%">Status:</td>
                                <td colspan="3">   {{$ouvidorias->status}}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>


                @endif



            </div> <!-- /panel-body -->


            <style type="text/css">a.btn:hover{text-decoration: none !important;}</style>


        </div> <!-- /pagina -->
    </div>
</div> <!-- /container - pagina -->




<div id="footer3" class="no-print" style="border-top:3px solid {{$portal->headercor}};">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <div class="text-center">
                    <strong>{{$portal->name}}</strong> <br>
                    <span>{{$portal->endereco}} - CEP: {{$portal->cep}} <br>
                        Telefone: {{$portal->telefone}}  | E-mail: {{$portal->email}} <br>
                </div>
            </div>
        </div>
    </div>
</div><script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.validationEngine-pt_BR.min.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.validationEngine.min.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/other-validations.js"></script>
<script type="text/javascript">
    $(function(){
        $('.validation').validationEngine({autoHidePrompt:true,promptPosition:"topLeft",scroll:false});
    });

    $(window).load(function() {
        $("#flexiselSlide").flexisel({visibleItems:6,clone:true,pauseOnHover:true,autoPlay:true,animationSpeed:200,autoPlaySpeed: 3000});
    });
</script>



<script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fancybox.js"></script>
<link href="{{url('')}}/templates/prefeitura1/licitacao/css/jquery.fancybox.css" rel="stylesheet">
<script type="text/javascript">
    $(function(){
        $('.fancybox').fancybox();
        $(".popup").fancybox({'width':'95%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});

        $(".open_modal_large").fancybox({'width':'98%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});
        $(".open_modal_small").fancybox({'width':'50%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});

        $('#news_icon').hover(function(){
            $(this).stop(true,true).animate({'right':'0px'}, 'fast');
        }, function(){
            $(this).stop(true,true).animate({'right':'-130px'}, 'fast');
        });


        $('#btn_mobile').on('click', function(){
            $('#menubar, .asidebar, #top-menubar').stop(true,true).slideToggle();
        });
    });

    $('[rel=popover]').popover();
    $('[rel=popover2]').popover();
    $('[rel=popover3]').popover();
</script>





</body>
</html>