<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Devtools\Cloudbuild\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * BuildStep describes a step to perform in the build pipeline.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.BuildStep</code>
 */
class BuildStep extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the container image that will run this particular build step.
     * If the image is already available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     *
     * Generated from protobuf field <code>repeated string env = 2;</code>
     */
    private $env;
    /**
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, these args
     * will be used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args will be used as the entrypoint,
     * and the remainder will be used as arguments.
     *
     * Generated from protobuf field <code>repeated string args = 3;</code>
     */
    private $args;
    /**
     * Working directory (relative to project source root) to use when running
     * this operation's container.
     *
     * Generated from protobuf field <code>string dir = 4;</code>
     */
    private $dir = '';
    /**
     * Optional unique identifier for this build step, used in wait_for to
     * reference this build step as a dependency.
     *
     * Generated from protobuf field <code>string id = 5;</code>
     */
    private $id = '';
    /**
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in wait_for
     * have completed successfully. If wait_for is empty, this build step will
     * start when all previous build steps in the Build.Steps list have completed
     * successfully.
     *
     * Generated from protobuf field <code>repeated string wait_for = 6;</code>
     */
    private $wait_for;
    /**
     * Optional entrypoint to be used instead of the build step image's default
     * If unset, the image's default will be used.
     *
     * Generated from protobuf field <code>string entrypoint = 7;</code>
     */
    private $entrypoint = '';
    /**
     * A list of environment variables which are encrypted using a Cloud KMS
     * crypto key. These values must be specified in the build's secrets.
     *
     * Generated from protobuf field <code>repeated string secret_env = 8;</code>
     */
    private $secret_env;
    /**
     * List of volumes to mount into the build step.
     * Each volume will be created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents will
     * be discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a mis-configured build request.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    private $volumes;
    /**
     * Stores timing information for executing this build step.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 10;</code>
     */
    private $timing = null;

    public function __construct() {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct();
    }

    /**
     * The name of the container image that will run this particular build step.
     * If the image is already available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the container image that will run this particular build step.
     * If the image is already available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     *
     * Generated from protobuf field <code>repeated string env = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEnv()
    {
        return $this->env;
    }

    /**
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     *
     * Generated from protobuf field <code>repeated string env = 2;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEnv($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->env = $arr;

        return $this;
    }

    /**
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, these args
     * will be used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args will be used as the entrypoint,
     * and the remainder will be used as arguments.
     *
     * Generated from protobuf field <code>repeated string args = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArgs()
    {
        return $this->args;
    }

    /**
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, these args
     * will be used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args will be used as the entrypoint,
     * and the remainder will be used as arguments.
     *
     * Generated from protobuf field <code>repeated string args = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArgs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->args = $arr;

        return $this;
    }

    /**
     * Working directory (relative to project source root) to use when running
     * this operation's container.
     *
     * Generated from protobuf field <code>string dir = 4;</code>
     * @return string
     */
    public function getDir()
    {
        return $this->dir;
    }

    /**
     * Working directory (relative to project source root) to use when running
     * this operation's container.
     *
     * Generated from protobuf field <code>string dir = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDir($var)
    {
        GPBUtil::checkString($var, True);
        $this->dir = $var;

        return $this;
    }

    /**
     * Optional unique identifier for this build step, used in wait_for to
     * reference this build step as a dependency.
     *
     * Generated from protobuf field <code>string id = 5;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Optional unique identifier for this build step, used in wait_for to
     * reference this build step as a dependency.
     *
     * Generated from protobuf field <code>string id = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in wait_for
     * have completed successfully. If wait_for is empty, this build step will
     * start when all previous build steps in the Build.Steps list have completed
     * successfully.
     *
     * Generated from protobuf field <code>repeated string wait_for = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWaitFor()
    {
        return $this->wait_for;
    }

    /**
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in wait_for
     * have completed successfully. If wait_for is empty, this build step will
     * start when all previous build steps in the Build.Steps list have completed
     * successfully.
     *
     * Generated from protobuf field <code>repeated string wait_for = 6;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWaitFor($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->wait_for = $arr;

        return $this;
    }

    /**
     * Optional entrypoint to be used instead of the build step image's default
     * If unset, the image's default will be used.
     *
     * Generated from protobuf field <code>string entrypoint = 7;</code>
     * @return string
     */
    public function getEntrypoint()
    {
        return $this->entrypoint;
    }

    /**
     * Optional entrypoint to be used instead of the build step image's default
     * If unset, the image's default will be used.
     *
     * Generated from protobuf field <code>string entrypoint = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setEntrypoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->entrypoint = $var;

        return $this;
    }

    /**
     * A list of environment variables which are encrypted using a Cloud KMS
     * crypto key. These values must be specified in the build's secrets.
     *
     * Generated from protobuf field <code>repeated string secret_env = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSecretEnv()
    {
        return $this->secret_env;
    }

    /**
     * A list of environment variables which are encrypted using a Cloud KMS
     * crypto key. These values must be specified in the build's secrets.
     *
     * Generated from protobuf field <code>repeated string secret_env = 8;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSecretEnv($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->secret_env = $arr;

        return $this;
    }

    /**
     * List of volumes to mount into the build step.
     * Each volume will be created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents will
     * be discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a mis-configured build request.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVolumes()
    {
        return $this->volumes;
    }

    /**
     * List of volumes to mount into the build step.
     * Each volume will be created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents will
     * be discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a mis-configured build request.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     * @param \Google\Devtools\Cloudbuild\V1\Volume[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVolumes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Devtools\Cloudbuild\V1\Volume::class);
        $this->volumes = $arr;

        return $this;
    }

    /**
     * Stores timing information for executing this build step.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 10;</code>
     * @return \Google\Devtools\Cloudbuild\V1\TimeSpan
     */
    public function getTiming()
    {
        return $this->timing;
    }

    /**
     * Stores timing information for executing this build step.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 10;</code>
     * @param \Google\Devtools\Cloudbuild\V1\TimeSpan $var
     * @return $this
     */
    public function setTiming($var)
    {
        GPBUtil::checkMessage($var, \Google\Devtools\Cloudbuild\V1\TimeSpan::class);
        $this->timing = $var;

        return $this;
    }

}

