<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Conditions that determine which objects will be transferred.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.ObjectConditions</code>
 */
class ObjectConditions extends \Google\Protobuf\Internal\Message
{
    /**
     * If unspecified, `minTimeElapsedSinceLastModification` takes a zero value
     * and `maxTimeElapsedSinceLastModification` takes the maximum possible
     * value of Duration. Objects that satisfy the object conditions
     * must either have a `lastModificationTime` greater or equal to
     * `NOW` - `maxTimeElapsedSinceLastModification` and less than
     * `NOW` - `minTimeElapsedSinceLastModification`, or not have a
     * `lastModificationTime`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     */
    private $min_time_elapsed_since_last_modification = null;
    /**
     * `maxTimeElapsedSinceLastModification` is the complement to
     * `minTimeElapsedSinceLastModification`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     */
    private $max_time_elapsed_since_last_modification = null;
    /**
     * If `includePrefixes` is specified, objects that satisfy the object
     * conditions must have names that start with one of the `includePrefixes`
     * and that do not start with any of the `excludePrefixes`. If `includePrefixes`
     * is not specified, all objects except those that have names starting with
     * one of the `excludePrefixes` must satisfy the object conditions.
     * Requirements:
     *   * Each include-prefix and exclude-prefix can contain any sequence of
     *     Unicode characters, of max length 1024 bytes when UTF8-encoded, and
     *     must not contain Carriage Return or Line Feed characters.  Wildcard
     *     matching and regular expression matching are not supported.
     *   * Each include-prefix and exclude-prefix must omit the leading slash.
     *     For example, to include the `requests.gz` object in a transfer from
     *     `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include
     *     prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix or the exclude-prefix values can be empty,
     *     if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace, i.e., no include-prefix may be a prefix of another
     *     include-prefix.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace, i.e., no exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If `includePrefixes` is specified, then each exclude-prefix must start
     *     with the value of a path explicitly included by `includePrefixes`.
     * The max size of `includePrefixes` is 1000.
     *
     * Generated from protobuf field <code>repeated string include_prefixes = 3;</code>
     */
    private $include_prefixes;
    /**
     * `excludePrefixes` must follow the requirements described for
     * `includePrefixes`.
     * The max size of `excludePrefixes` is 1000.
     *
     * Generated from protobuf field <code>repeated string exclude_prefixes = 4;</code>
     */
    private $exclude_prefixes;

    public function __construct() {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct();
    }

    /**
     * If unspecified, `minTimeElapsedSinceLastModification` takes a zero value
     * and `maxTimeElapsedSinceLastModification` takes the maximum possible
     * value of Duration. Objects that satisfy the object conditions
     * must either have a `lastModificationTime` greater or equal to
     * `NOW` - `maxTimeElapsedSinceLastModification` and less than
     * `NOW` - `minTimeElapsedSinceLastModification`, or not have a
     * `lastModificationTime`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getMinTimeElapsedSinceLastModification()
    {
        return $this->min_time_elapsed_since_last_modification;
    }

    /**
     * If unspecified, `minTimeElapsedSinceLastModification` takes a zero value
     * and `maxTimeElapsedSinceLastModification` takes the maximum possible
     * value of Duration. Objects that satisfy the object conditions
     * must either have a `lastModificationTime` greater or equal to
     * `NOW` - `maxTimeElapsedSinceLastModification` and less than
     * `NOW` - `minTimeElapsedSinceLastModification`, or not have a
     * `lastModificationTime`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMinTimeElapsedSinceLastModification($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->min_time_elapsed_since_last_modification = $var;

        return $this;
    }

    /**
     * `maxTimeElapsedSinceLastModification` is the complement to
     * `minTimeElapsedSinceLastModification`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getMaxTimeElapsedSinceLastModification()
    {
        return $this->max_time_elapsed_since_last_modification;
    }

    /**
     * `maxTimeElapsedSinceLastModification` is the complement to
     * `minTimeElapsedSinceLastModification`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxTimeElapsedSinceLastModification($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->max_time_elapsed_since_last_modification = $var;

        return $this;
    }

    /**
     * If `includePrefixes` is specified, objects that satisfy the object
     * conditions must have names that start with one of the `includePrefixes`
     * and that do not start with any of the `excludePrefixes`. If `includePrefixes`
     * is not specified, all objects except those that have names starting with
     * one of the `excludePrefixes` must satisfy the object conditions.
     * Requirements:
     *   * Each include-prefix and exclude-prefix can contain any sequence of
     *     Unicode characters, of max length 1024 bytes when UTF8-encoded, and
     *     must not contain Carriage Return or Line Feed characters.  Wildcard
     *     matching and regular expression matching are not supported.
     *   * Each include-prefix and exclude-prefix must omit the leading slash.
     *     For example, to include the `requests.gz` object in a transfer from
     *     `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include
     *     prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix or the exclude-prefix values can be empty,
     *     if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace, i.e., no include-prefix may be a prefix of another
     *     include-prefix.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace, i.e., no exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If `includePrefixes` is specified, then each exclude-prefix must start
     *     with the value of a path explicitly included by `includePrefixes`.
     * The max size of `includePrefixes` is 1000.
     *
     * Generated from protobuf field <code>repeated string include_prefixes = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIncludePrefixes()
    {
        return $this->include_prefixes;
    }

    /**
     * If `includePrefixes` is specified, objects that satisfy the object
     * conditions must have names that start with one of the `includePrefixes`
     * and that do not start with any of the `excludePrefixes`. If `includePrefixes`
     * is not specified, all objects except those that have names starting with
     * one of the `excludePrefixes` must satisfy the object conditions.
     * Requirements:
     *   * Each include-prefix and exclude-prefix can contain any sequence of
     *     Unicode characters, of max length 1024 bytes when UTF8-encoded, and
     *     must not contain Carriage Return or Line Feed characters.  Wildcard
     *     matching and regular expression matching are not supported.
     *   * Each include-prefix and exclude-prefix must omit the leading slash.
     *     For example, to include the `requests.gz` object in a transfer from
     *     `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include
     *     prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix or the exclude-prefix values can be empty,
     *     if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace, i.e., no include-prefix may be a prefix of another
     *     include-prefix.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace, i.e., no exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If `includePrefixes` is specified, then each exclude-prefix must start
     *     with the value of a path explicitly included by `includePrefixes`.
     * The max size of `includePrefixes` is 1000.
     *
     * Generated from protobuf field <code>repeated string include_prefixes = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIncludePrefixes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->include_prefixes = $arr;

        return $this;
    }

    /**
     * `excludePrefixes` must follow the requirements described for
     * `includePrefixes`.
     * The max size of `excludePrefixes` is 1000.
     *
     * Generated from protobuf field <code>repeated string exclude_prefixes = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludePrefixes()
    {
        return $this->exclude_prefixes;
    }

    /**
     * `excludePrefixes` must follow the requirements described for
     * `includePrefixes`.
     * The max size of `excludePrefixes` is 1000.
     *
     * Generated from protobuf field <code>repeated string exclude_prefixes = 4;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludePrefixes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->exclude_prefixes = $arr;

        return $this;
    }

}

