<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ml/v1/job_service.proto

namespace Google\Cloud\Ml\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents input parameters for a training job.
 *
 * Generated from protobuf message <code>google.cloud.ml.v1.TrainingInput</code>
 */
class TrainingInput extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Specifies the machine types, the number of replicas for workers
     * and parameter servers.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.TrainingInput.ScaleTier scale_tier = 1;</code>
     */
    private $scale_tier = 0;
    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's master worker.
     * The following types are supported:
     * <dl>
     *   <dt>standard</dt>
     *   <dd>
     *   A basic machine configuration suitable for training simple models with
     *   small to moderate datasets.
     *   </dd>
     *   <dt>large_model</dt>
     *   <dd>
     *   A machine with a lot of memory, specially suited for parameter servers
     *   when your model is large (having many hidden layers or layers with very
     *   large numbers of nodes).
     *   </dd>
     *   <dt>complex_model_s</dt>
     *   <dd>
     *   A machine suitable for the master and workers of the cluster when your
     *   model requires more computation than the standard machine can handle
     *   satisfactorily.
     *   </dd>
     *   <dt>complex_model_m</dt>
     *   <dd>
     *   A machine with roughly twice the number of cores and roughly double the
     *   memory of <code suppresswarning="true">complex_model_s</code>.
     *   </dd>
     *   <dt>complex_model_l</dt>
     *   <dd>
     *   A machine with roughly twice the number of cores and roughly double the
     *   memory of <code suppresswarning="true">complex_model_m</code>.
     *   </dd>
     *   <dt>standard_gpu</dt>
     *   <dd>
     *   A machine equivalent to <code suppresswarning="true">standard</code> that
     *   also includes a
     *   <a href="ml/docs/how-tos/using-gpus">
     *   GPU that you can use in your trainer</a>.
     *   </dd>
     *   <dt>complex_model_m_gpu</dt>
     *   <dd>
     *   A machine equivalent to
     *   <code suppresswarning="true">coplex_model_m</code> that also includes
     *   four GPUs.
     *   </dd>
     * </dl>
     * You must set this value when `scaleTier` is set to `CUSTOM`.
     *
     * Generated from protobuf field <code>string master_type = 2;</code>
     */
    private $master_type = '';
    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's worker nodes.
     * The supported values are the same as those described in the entry for
     * `masterType`.
     * This value must be present when `scaleTier` is set to `CUSTOM` and
     * `workerCount` is greater than zero.
     *
     * Generated from protobuf field <code>string worker_type = 3;</code>
     */
    private $worker_type = '';
    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's parameter server.
     * The supported values are the same as those described in the entry for
     * `master_type`.
     * This value must be present when `scaleTier` is set to `CUSTOM` and
     * `parameter_server_count` is greater than zero.
     *
     * Generated from protobuf field <code>string parameter_server_type = 4;</code>
     */
    private $parameter_server_type = '';
    /**
     * Optional. The number of worker replicas to use for the training job. Each
     * replica in the cluster will be of the type specified in `worker_type`.
     * This value can only be used when `scale_tier` is set to `CUSTOM`. If you
     * set this value, you must also set `worker_type`.
     *
     * Generated from protobuf field <code>int64 worker_count = 5;</code>
     */
    private $worker_count = 0;
    /**
     * Optional. The number of parameter server replicas to use for the training
     * job. Each replica in the cluster will be of the type specified in
     * `parameter_server_type`.
     * This value can only be used when `scale_tier` is set to `CUSTOM`.If you
     * set this value, you must also set `parameter_server_type`.
     *
     * Generated from protobuf field <code>int64 parameter_server_count = 6;</code>
     */
    private $parameter_server_count = 0;
    /**
     * Required. The Google Cloud Storage location of the packages with
     * the training program and any additional dependencies.
     *
     * Generated from protobuf field <code>repeated string package_uris = 7;</code>
     */
    private $package_uris;
    /**
     * Required. The Python module name to run after installing the packages.
     *
     * Generated from protobuf field <code>string python_module = 8;</code>
     */
    private $python_module = '';
    /**
     * Optional. Command line arguments to pass to the program.
     *
     * Generated from protobuf field <code>repeated string args = 10;</code>
     */
    private $args;
    /**
     * Optional. The set of Hyperparameters to tune.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.HyperparameterSpec hyperparameters = 12;</code>
     */
    private $hyperparameters = null;
    /**
     * Required. The Google Compute Engine region to run the training job in.
     *
     * Generated from protobuf field <code>string region = 14;</code>
     */
    private $region = '';
    /**
     * Optional. A Google Cloud Storage path in which to store training outputs
     * and other data needed for training. This path is passed to your TensorFlow
     * program as the 'job_dir' command-line argument. The benefit of specifying
     * this field is that Cloud ML validates the path for use in training.
     *
     * Generated from protobuf field <code>string job_dir = 16;</code>
     */
    private $job_dir = '';
    /**
     * Optional. The Google Cloud ML runtime version to use for training.  If not
     * set, Google Cloud ML will choose the latest stable version.
     *
     * Generated from protobuf field <code>string runtime_version = 15;</code>
     */
    private $runtime_version = '';

    public function __construct() {
        \GPBMetadata\Google\Cloud\Ml\V1\JobService::initOnce();
        parent::__construct();
    }

    /**
     * Required. Specifies the machine types, the number of replicas for workers
     * and parameter servers.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.TrainingInput.ScaleTier scale_tier = 1;</code>
     * @return int
     */
    public function getScaleTier()
    {
        return $this->scale_tier;
    }

    /**
     * Required. Specifies the machine types, the number of replicas for workers
     * and parameter servers.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.TrainingInput.ScaleTier scale_tier = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setScaleTier($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ml\V1\TrainingInput_ScaleTier::class);
        $this->scale_tier = $var;

        return $this;
    }

    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's master worker.
     * The following types are supported:
     * <dl>
     *   <dt>standard</dt>
     *   <dd>
     *   A basic machine configuration suitable for training simple models with
     *   small to moderate datasets.
     *   </dd>
     *   <dt>large_model</dt>
     *   <dd>
     *   A machine with a lot of memory, specially suited for parameter servers
     *   when your model is large (having many hidden layers or layers with very
     *   large numbers of nodes).
     *   </dd>
     *   <dt>complex_model_s</dt>
     *   <dd>
     *   A machine suitable for the master and workers of the cluster when your
     *   model requires more computation than the standard machine can handle
     *   satisfactorily.
     *   </dd>
     *   <dt>complex_model_m</dt>
     *   <dd>
     *   A machine with roughly twice the number of cores and roughly double the
     *   memory of <code suppresswarning="true">complex_model_s</code>.
     *   </dd>
     *   <dt>complex_model_l</dt>
     *   <dd>
     *   A machine with roughly twice the number of cores and roughly double the
     *   memory of <code suppresswarning="true">complex_model_m</code>.
     *   </dd>
     *   <dt>standard_gpu</dt>
     *   <dd>
     *   A machine equivalent to <code suppresswarning="true">standard</code> that
     *   also includes a
     *   <a href="ml/docs/how-tos/using-gpus">
     *   GPU that you can use in your trainer</a>.
     *   </dd>
     *   <dt>complex_model_m_gpu</dt>
     *   <dd>
     *   A machine equivalent to
     *   <code suppresswarning="true">coplex_model_m</code> that also includes
     *   four GPUs.
     *   </dd>
     * </dl>
     * You must set this value when `scaleTier` is set to `CUSTOM`.
     *
     * Generated from protobuf field <code>string master_type = 2;</code>
     * @return string
     */
    public function getMasterType()
    {
        return $this->master_type;
    }

    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's master worker.
     * The following types are supported:
     * <dl>
     *   <dt>standard</dt>
     *   <dd>
     *   A basic machine configuration suitable for training simple models with
     *   small to moderate datasets.
     *   </dd>
     *   <dt>large_model</dt>
     *   <dd>
     *   A machine with a lot of memory, specially suited for parameter servers
     *   when your model is large (having many hidden layers or layers with very
     *   large numbers of nodes).
     *   </dd>
     *   <dt>complex_model_s</dt>
     *   <dd>
     *   A machine suitable for the master and workers of the cluster when your
     *   model requires more computation than the standard machine can handle
     *   satisfactorily.
     *   </dd>
     *   <dt>complex_model_m</dt>
     *   <dd>
     *   A machine with roughly twice the number of cores and roughly double the
     *   memory of <code suppresswarning="true">complex_model_s</code>.
     *   </dd>
     *   <dt>complex_model_l</dt>
     *   <dd>
     *   A machine with roughly twice the number of cores and roughly double the
     *   memory of <code suppresswarning="true">complex_model_m</code>.
     *   </dd>
     *   <dt>standard_gpu</dt>
     *   <dd>
     *   A machine equivalent to <code suppresswarning="true">standard</code> that
     *   also includes a
     *   <a href="ml/docs/how-tos/using-gpus">
     *   GPU that you can use in your trainer</a>.
     *   </dd>
     *   <dt>complex_model_m_gpu</dt>
     *   <dd>
     *   A machine equivalent to
     *   <code suppresswarning="true">coplex_model_m</code> that also includes
     *   four GPUs.
     *   </dd>
     * </dl>
     * You must set this value when `scaleTier` is set to `CUSTOM`.
     *
     * Generated from protobuf field <code>string master_type = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setMasterType($var)
    {
        GPBUtil::checkString($var, True);
        $this->master_type = $var;

        return $this;
    }

    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's worker nodes.
     * The supported values are the same as those described in the entry for
     * `masterType`.
     * This value must be present when `scaleTier` is set to `CUSTOM` and
     * `workerCount` is greater than zero.
     *
     * Generated from protobuf field <code>string worker_type = 3;</code>
     * @return string
     */
    public function getWorkerType()
    {
        return $this->worker_type;
    }

    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's worker nodes.
     * The supported values are the same as those described in the entry for
     * `masterType`.
     * This value must be present when `scaleTier` is set to `CUSTOM` and
     * `workerCount` is greater than zero.
     *
     * Generated from protobuf field <code>string worker_type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerType($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_type = $var;

        return $this;
    }

    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's parameter server.
     * The supported values are the same as those described in the entry for
     * `master_type`.
     * This value must be present when `scaleTier` is set to `CUSTOM` and
     * `parameter_server_count` is greater than zero.
     *
     * Generated from protobuf field <code>string parameter_server_type = 4;</code>
     * @return string
     */
    public function getParameterServerType()
    {
        return $this->parameter_server_type;
    }

    /**
     * Optional. Specifies the type of virtual machine to use for your training
     * job's parameter server.
     * The supported values are the same as those described in the entry for
     * `master_type`.
     * This value must be present when `scaleTier` is set to `CUSTOM` and
     * `parameter_server_count` is greater than zero.
     *
     * Generated from protobuf field <code>string parameter_server_type = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setParameterServerType($var)
    {
        GPBUtil::checkString($var, True);
        $this->parameter_server_type = $var;

        return $this;
    }

    /**
     * Optional. The number of worker replicas to use for the training job. Each
     * replica in the cluster will be of the type specified in `worker_type`.
     * This value can only be used when `scale_tier` is set to `CUSTOM`. If you
     * set this value, you must also set `worker_type`.
     *
     * Generated from protobuf field <code>int64 worker_count = 5;</code>
     * @return int|string
     */
    public function getWorkerCount()
    {
        return $this->worker_count;
    }

    /**
     * Optional. The number of worker replicas to use for the training job. Each
     * replica in the cluster will be of the type specified in `worker_type`.
     * This value can only be used when `scale_tier` is set to `CUSTOM`. If you
     * set this value, you must also set `worker_type`.
     *
     * Generated from protobuf field <code>int64 worker_count = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setWorkerCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->worker_count = $var;

        return $this;
    }

    /**
     * Optional. The number of parameter server replicas to use for the training
     * job. Each replica in the cluster will be of the type specified in
     * `parameter_server_type`.
     * This value can only be used when `scale_tier` is set to `CUSTOM`.If you
     * set this value, you must also set `parameter_server_type`.
     *
     * Generated from protobuf field <code>int64 parameter_server_count = 6;</code>
     * @return int|string
     */
    public function getParameterServerCount()
    {
        return $this->parameter_server_count;
    }

    /**
     * Optional. The number of parameter server replicas to use for the training
     * job. Each replica in the cluster will be of the type specified in
     * `parameter_server_type`.
     * This value can only be used when `scale_tier` is set to `CUSTOM`.If you
     * set this value, you must also set `parameter_server_type`.
     *
     * Generated from protobuf field <code>int64 parameter_server_count = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setParameterServerCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->parameter_server_count = $var;

        return $this;
    }

    /**
     * Required. The Google Cloud Storage location of the packages with
     * the training program and any additional dependencies.
     *
     * Generated from protobuf field <code>repeated string package_uris = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPackageUris()
    {
        return $this->package_uris;
    }

    /**
     * Required. The Google Cloud Storage location of the packages with
     * the training program and any additional dependencies.
     *
     * Generated from protobuf field <code>repeated string package_uris = 7;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPackageUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->package_uris = $arr;

        return $this;
    }

    /**
     * Required. The Python module name to run after installing the packages.
     *
     * Generated from protobuf field <code>string python_module = 8;</code>
     * @return string
     */
    public function getPythonModule()
    {
        return $this->python_module;
    }

    /**
     * Required. The Python module name to run after installing the packages.
     *
     * Generated from protobuf field <code>string python_module = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setPythonModule($var)
    {
        GPBUtil::checkString($var, True);
        $this->python_module = $var;

        return $this;
    }

    /**
     * Optional. Command line arguments to pass to the program.
     *
     * Generated from protobuf field <code>repeated string args = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArgs()
    {
        return $this->args;
    }

    /**
     * Optional. Command line arguments to pass to the program.
     *
     * Generated from protobuf field <code>repeated string args = 10;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArgs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->args = $arr;

        return $this;
    }

    /**
     * Optional. The set of Hyperparameters to tune.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.HyperparameterSpec hyperparameters = 12;</code>
     * @return \Google\Cloud\Ml\V1\HyperparameterSpec
     */
    public function getHyperparameters()
    {
        return $this->hyperparameters;
    }

    /**
     * Optional. The set of Hyperparameters to tune.
     *
     * Generated from protobuf field <code>.google.cloud.ml.v1.HyperparameterSpec hyperparameters = 12;</code>
     * @param \Google\Cloud\Ml\V1\HyperparameterSpec $var
     * @return $this
     */
    public function setHyperparameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ml\V1\HyperparameterSpec::class);
        $this->hyperparameters = $var;

        return $this;
    }

    /**
     * Required. The Google Compute Engine region to run the training job in.
     *
     * Generated from protobuf field <code>string region = 14;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * Required. The Google Compute Engine region to run the training job in.
     *
     * Generated from protobuf field <code>string region = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * Optional. A Google Cloud Storage path in which to store training outputs
     * and other data needed for training. This path is passed to your TensorFlow
     * program as the 'job_dir' command-line argument. The benefit of specifying
     * this field is that Cloud ML validates the path for use in training.
     *
     * Generated from protobuf field <code>string job_dir = 16;</code>
     * @return string
     */
    public function getJobDir()
    {
        return $this->job_dir;
    }

    /**
     * Optional. A Google Cloud Storage path in which to store training outputs
     * and other data needed for training. This path is passed to your TensorFlow
     * program as the 'job_dir' command-line argument. The benefit of specifying
     * this field is that Cloud ML validates the path for use in training.
     *
     * Generated from protobuf field <code>string job_dir = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setJobDir($var)
    {
        GPBUtil::checkString($var, True);
        $this->job_dir = $var;

        return $this;
    }

    /**
     * Optional. The Google Cloud ML runtime version to use for training.  If not
     * set, Google Cloud ML will choose the latest stable version.
     *
     * Generated from protobuf field <code>string runtime_version = 15;</code>
     * @return string
     */
    public function getRuntimeVersion()
    {
        return $this->runtime_version;
    }

    /**
     * Optional. The Google Cloud ML runtime version to use for training.  If not
     * set, Google Cloud ML will choose the latest stable version.
     *
     * Generated from protobuf field <code>string runtime_version = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntimeVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime_version = $var;

        return $this;
    }

}

