<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/functions/v1beta2/functions.proto

namespace Google\Cloud\Functions\V1beta2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes the location of the function source in a remote repository.
 *
 * Generated from protobuf message <code>google.cloud.functions.v1beta2.SourceRepository</code>
 */
class SourceRepository extends \Google\Protobuf\Internal\Message
{
    /**
     * URL to the hosted repository where the function is defined. Only paths in
     * https://source.developers.google.com domain are supported. The path should
     * contain the name of the repository.
     *
     * Generated from protobuf field <code>string repository_url = 1;</code>
     */
    private $repository_url = '';
    /**
     * The path within the repository where the function is defined. The path
     * should point to the directory where Cloud Functions files are located. Use
     * "/" if the function is defined directly in the root directory of a
     * repository.
     *
     * Generated from protobuf field <code>string source_path = 2;</code>
     */
    private $source_path = '';
    /**
     * Output only. The id of the revision that was resolved at the moment of
     * function creation or update. For example when a user deployed from a
     * branch, it will be the revision id of the latest change on this branch at
     * that time. If user deployed from revision then this value will be always
     * equal to the revision specified by the user.
     *
     * Generated from protobuf field <code>string deployed_revision = 6;</code>
     */
    private $deployed_revision = '';
    protected $version;

    public function __construct() {
        \GPBMetadata\Google\Cloud\Functions\V1Beta2\Functions::initOnce();
        parent::__construct();
    }

    /**
     * URL to the hosted repository where the function is defined. Only paths in
     * https://source.developers.google.com domain are supported. The path should
     * contain the name of the repository.
     *
     * Generated from protobuf field <code>string repository_url = 1;</code>
     * @return string
     */
    public function getRepositoryUrl()
    {
        return $this->repository_url;
    }

    /**
     * URL to the hosted repository where the function is defined. Only paths in
     * https://source.developers.google.com domain are supported. The path should
     * contain the name of the repository.
     *
     * Generated from protobuf field <code>string repository_url = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setRepositoryUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->repository_url = $var;

        return $this;
    }

    /**
     * The path within the repository where the function is defined. The path
     * should point to the directory where Cloud Functions files are located. Use
     * "/" if the function is defined directly in the root directory of a
     * repository.
     *
     * Generated from protobuf field <code>string source_path = 2;</code>
     * @return string
     */
    public function getSourcePath()
    {
        return $this->source_path;
    }

    /**
     * The path within the repository where the function is defined. The path
     * should point to the directory where Cloud Functions files are located. Use
     * "/" if the function is defined directly in the root directory of a
     * repository.
     *
     * Generated from protobuf field <code>string source_path = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSourcePath($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_path = $var;

        return $this;
    }

    /**
     * The name of the branch from which the function should be fetched.
     *
     * Generated from protobuf field <code>string branch = 3;</code>
     * @return string
     */
    public function getBranch()
    {
        return $this->readOneof(3);
    }

    /**
     * The name of the branch from which the function should be fetched.
     *
     * Generated from protobuf field <code>string branch = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setBranch($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The name of the tag that captures the state of the repository from
     * which the function should be fetched.
     *
     * Generated from protobuf field <code>string tag = 4;</code>
     * @return string
     */
    public function getTag()
    {
        return $this->readOneof(4);
    }

    /**
     * The name of the tag that captures the state of the repository from
     * which the function should be fetched.
     *
     * Generated from protobuf field <code>string tag = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setTag($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The id of the revision that captures the state of the repository from
     * which the function should be fetched.
     *
     * Generated from protobuf field <code>string revision = 5;</code>
     * @return string
     */
    public function getRevision()
    {
        return $this->readOneof(5);
    }

    /**
     * The id of the revision that captures the state of the repository from
     * which the function should be fetched.
     *
     * Generated from protobuf field <code>string revision = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setRevision($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Output only. The id of the revision that was resolved at the moment of
     * function creation or update. For example when a user deployed from a
     * branch, it will be the revision id of the latest change on this branch at
     * that time. If user deployed from revision then this value will be always
     * equal to the revision specified by the user.
     *
     * Generated from protobuf field <code>string deployed_revision = 6;</code>
     * @return string
     */
    public function getDeployedRevision()
    {
        return $this->deployed_revision;
    }

    /**
     * Output only. The id of the revision that was resolved at the moment of
     * function creation or update. For example when a user deployed from a
     * branch, it will be the revision id of the latest change on this branch at
     * that time. If user deployed from revision then this value will be always
     * equal to the revision specified by the user.
     *
     * Generated from protobuf field <code>string deployed_revision = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDeployedRevision($var)
    {
        GPBUtil::checkString($var, True);
        $this->deployed_revision = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getVersion()
    {
        return $this->whichOneof("version");
    }

}

