<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class VirtualClusterConfig extends \Google\Model
{
  /**
   * @var AuxiliaryServicesConfig
   */
  public $auxiliaryServicesConfig;
  protected $auxiliaryServicesConfigType = AuxiliaryServicesConfig::class;
  protected $auxiliaryServicesConfigDataType = '';
  /**
   * @var KubernetesClusterConfig
   */
  public $kubernetesClusterConfig;
  protected $kubernetesClusterConfigType = KubernetesClusterConfig::class;
  protected $kubernetesClusterConfigDataType = '';
  /**
   * @var string
   */
  public $stagingBucket;

  /**
   * @param AuxiliaryServicesConfig
   */
  public function setAuxiliaryServicesConfig(AuxiliaryServicesConfig $auxiliaryServicesConfig)
  {
    $this->auxiliaryServicesConfig = $auxiliaryServicesConfig;
  }
  /**
   * @return AuxiliaryServicesConfig
   */
  public function getAuxiliaryServicesConfig()
  {
    return $this->auxiliaryServicesConfig;
  }
  /**
   * @param KubernetesClusterConfig
   */
  public function setKubernetesClusterConfig(KubernetesClusterConfig $kubernetesClusterConfig)
  {
    $this->kubernetesClusterConfig = $kubernetesClusterConfig;
  }
  /**
   * @return KubernetesClusterConfig
   */
  public function getKubernetesClusterConfig()
  {
    return $this->kubernetesClusterConfig;
  }
  /**
   * @param string
   */
  public function setStagingBucket($stagingBucket)
  {
    $this->stagingBucket = $stagingBucket;
  }
  /**
   * @return string
   */
  public function getStagingBucket()
  {
    return $this->stagingBucket;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VirtualClusterConfig::class, 'Google_Service_Dataproc_VirtualClusterConfig');
