<?php

use App\Http\Controllers\Admin\LoginController;
use App\jwtStone;
use Illuminate\Http\Request;
use App\Twofish;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::post('organizador/authenticate', 'Organizador\Api\AuthController@authenticate');
Route::post('getnoticias', [\App\Http\Controllers\Api\NoticiasController::class, 'getnoticias']);
Route::post('getnoticiastotal', [\App\Http\Controllers\Api\NoticiasController::class, 'getnoticiastotal']);
Route::post('getservicos', [\App\Http\Controllers\Api\ServicosController::class, 'getservicos']);
Route::post('getlinks', [\App\Http\Controllers\Api\ServicosController::class, 'getlinks']);

Route::group(['prefix'=>'organizador/painel','middleware' => ['auth.organizador.jwt']], function() {

    Route::get('eventos', 'Organizador\Api\EventosController@get');
    Route::get('vendas/{idevento}', 'Organizador\Api\EventosController@vendas');
    Route::get('getingressos/{idevento}', 'Organizador\Api\EventosController@getingressos');
    Route::post('validartoken', 'Organizador\Api\EventosController@validartoken');


});
