@extends('layouts.site')

@section('title')
<title> Sobre Nós - {{env('APP_NAME')}}</title>
@endsection

@section('content')

    <div id="wrapper">
        <div class="content-holder elem scale-bg2 transition3" >
            <div class="content">
                <!-- background animation  -->
                <div class="bg-animate"><img src="{{asset('site/images/body-bg.png')}}"  class="respimg" alt=""></div>
                <!-- wrapper inner -->
                <div class="wrapper-inner">
                    <section class="no-padding no-border" id="sec1">
                        <!-- page title -->
                        <div class="container">
                            <div class="page-title no-border">
                                <h2>{{$config->fraseimpacto}}</h2>
                                <h3><span>{{$config->subFrasedeImpacto}}</span></h3>
                            </div>
                        </div>
                    </section>
                    <div class="container">
                        <section class="no-border">
                            <div class="full-width-holder">
                                <div class="fullwidth-slider-holder">
                                    <div class="customNavigation">
                                        <a class="next-slide transition"><i class="fa fa-long-arrow-right"></i></a>
                                        <a class="prev-slide transition"><i class="fa fa-long-arrow-left"></i></a>
                                    </div>
                                    <div class="full-width owl-carousel">
                                        @foreach($galeriasquemsomos as $g)
                                                <div class="item">
                                                    <img src="{{asset('ADM/'.$g->imagem)}}" class="respimg" alt="">
                                                </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </section>
                        <!-- full width slider end -->
                        <section>
                            <div class="row">
                                <div class="col-md-8">
                                    {!! $config->historia !!}
                               </div>
                            </div>
                        </section>
                        <!-- about text end -->
                        <section>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class=" row">
                                        <!-- 1 -->


                                        <div class="inline-facts col-md-3 ">
                                            <div class="milestone-counter">
                                                <img src="{{asset('site/logo_m.png')}}" width="100%" alt="">
                                            </div>
                                        </div>


                                        <div class="inline-facts col-md-5 ">
                                            <div class="milestone-counter">
                                                <div class="stats animaper">
                                                    <div class="num" data-content="{!! $config->projetosexecultados !!}" data-num="{!! $config->projetosexecultados !!}">0</div>
                                                </div>
                                            </div>
                                            <h6>Projetos executados</h6>
                                        </div>  
                                        <!-- 1 -->


                                        <!-- 3 -->
                                        <div class="inline-facts col-md-4 ">
                                            <div class="milestone-counter">
                                                <div class="stats animaper">
                                                    <div class="num" data-content="{!! $config->cidades !!}" data-num="{!! $config->cidades !!}">0</div>
                                                </div>
                                            </div>
                                            <h6>Cidades</h6>
                                        </div>
                                        <!-- 3 -->

                                    </div>
                                </div>
                            </div>
                        </section>
                        <!-- team -->
                        <section id="sec2">
                            <div class="section-title">
                                <h3>Nossa Equipe</h3>
                            </div>
                            <ul class="team-holder">
@foreach($equipe as $e)
                                <!-- 1 -->
                                <li>
                                    <div class="team-box">
                                        <div class="team-photo">
                                            <div class="overlay"></div>
                                            <ul class="team-social">
                                                <li><a href="{{$e->facebook}}" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                                <li><a href="{{$e->instagran}}" target="_blank"><i class="fa fa-instagram"></i></a></li>
                                                <li><a href="https://wa.me/{{$e->whatsap}}" target="_blank"><i class="fa fa-whatsapp"></i></a></li>
                                            </ul>
                                            <img src="{{asset('ADM/'.$e->imagem)}}" alt="" class="respimg"><span></span>
                                        </div>
                                        <div class="team-info">
                                            <h3>{{$e->nome}}</h3>
                                            <h4>{{$e->funcao}}</h4><br/>
                                            <p>{{$e->biografia}}</p>
                                        </div>
                                    </div>
                                </li>
                                @endforeach
                            </ul>
                        </section>
                        <!-- team end   -->
                        <!-- story / resume   -->

                        <!-- resume / story end -->
                        <!-- services  -->
                        <section id="sec4">
                            <div class="section-title">
                                <h3>O que fazemos</h3>
                            </div>
                            <div class="row">
                                <!-- services 1 -->
                                <div class="col-md-4">
                                    <div class="services-box box-item">
                                        <a href="{{route('site.portifolio')}}?tipo=comercial">
                                            <span class="overlay"></span>
                                            <img src="{{asset('site/images/folio/thumbs/9.jpg')}}"  alt="" class="respimg">
                                        </a>
                                        <div class="services-info">
                                            <h4>Projetos Comerciais</h4>

                                        </div>
                                    </div>
                                </div>
                                <!-- services 2 -->
                                <div class="col-md-4">
                                    <div class="services-box">
                                        <div class="services-image box-item">
                                            <a href="{{route('site.portifolio')}}?tipo=residencial">
                                                <span class="overlay"></span>
                                                <img src="{{asset('site/images/folio/thumbs/3.jpg')}}"  alt="" class="respimg">
                                            </a>
                                        </div>
                                        <div class="services-info">
                                            <h4>Projetos Residenciais</h4>

                                        </div>
                                    </div>
                                </div>
                                <!-- services 3 -->
                                <div class="col-md-4">
                                    <div class="services-box">
                                        <div class="services-image box-item">
                                            <a href="{{route('site.portifolio')}}?tipo=interiores" >
                                                <span class="overlay"></span>
                                                <img src="{{asset('site/images/folio/thumbs/11.jpg')}}"  alt="" class="respimg">
                                            </a>
                                        </div>
                                        <div class="services-info">
                                            <h4>Projeto de Interiores</h4>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
                <!-- wrapper inner end   -->
                <!-- parallax column   -->
                <div class="img-wrap">
                    <div class="bg" style="background-image: url({{asset('ADM/'.\App\Models\ConfiguracaoSite::find(1)->imagemsobrenos)}})"  data-top-bottom="transform: translateY(300px);" data-bottom-top="transform: translateY(-300px);"></div>
                </div>
                <!-- parallax column end   -->
                <!--to top    -->
                <div class="to-top">
                    <i class="fa fa-long-arrow-up"></i>
                </div>
                <!-- to top  end -->
                <!--=============== footer ===============-->
                <div class="height-emulator"></div>
                @include ('site.repeat.footer')
                <!-- footer end    -->
            </div>
            <!-- content  end  -->
        </div>
        <!-- content-holder  end  -->
    </div>


@endsection

@section('script')

@endsection

