@extends('layouts.site')

@section('title')
<title>{{$evento->nome}} - {{env('APP_NAME')}} </title>

  @if(isset($trackeamento->googleanalitis))  {!!  $trackeamento->googleanalitis!!} @endif
  @if(isset($trackeamento->hotjar))  {!!  $trackeamento->hotjar!!} @endif
  @if(isset($trackeamento->googlepixel))  {!!  $trackeamento->googlepixel!!} @endif


@endsection

@section('content')

    <main id="main" class="site-main single single-02">
        <div class="place">
            <div class="slick-sliders">
                <div class="slick-slider" data-item="1" data-arrows="true" data-itemscroll="1" data-dots="true" data-infinite="true" data-centermode="true" data-centerpadding="418px" data-tabletitem="1" data-tabletscroll="1" data-tabletpadding="70px" data-mobileitem="1" data-mobilescroll="1" data-mobilepadding="30px">
                    <div class="place-slider__item bd"><a title="{{$evento->nome}}" href="#"><img src="{{asset('ADM/'.$evento->imagem)}}" alt="{{$evento->nome}}"></a></div>
                    <div class="place-slider__item bd"><a title="{{$evento->nome}}" href="#"><img src="{{asset('ADM/'.$evento->imagem)}}" alt="{{$evento->nome}}"></a></div>

                </div><!-- .page-title -->
                <div class="place-share">


                </div><!-- .place-share -->
                <div class="place-slider__nav slick-nav">
                    <div class="place-slider__prev slick-nav__prev">
                        <i class="las la-angle-left"></i>
                    </div><!-- .place-slider__prev -->
                    <div class="place-slider__next slick-nav__next">
                        <i class="las la-angle-right"></i>
                    </div><!-- .place-slider__next -->
                </div><!-- .place-slider__nav -->
            </div><!-- .place-slider -->
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="place__left">
                            <ul class="place__breadcrumbs breadcrumbs">
                                <li><a title="France" href="#">{{$evento->categoria}}</a></li>

                            </ul><!-- .place__breadcrumbs -->
                            <div class="place__box place__box--npd">
                                <h1>{{$evento->nome}}</h1>

                            </div><!-- .place__box -->

                            <div class="place__box place__box-overview">
                                <h3>Conheça Mais</h3>
                                <div class="place__desc">{!! $evento->descricao  !!}</div><!-- .place__desc -->
                                <a href="#" class="show-more" title="Show More">Continuar lendo..</a>
                            </div>

                            <div class="place__box">
                                <h3>Contato da Organização</h3>
                                <ul class="place__contact">
                                    <li>
                                        <i class="la la-phone"></i>
                                        <a href="tel:{{substr($evento->whatsappResponsavel, 2)}}">{{substr($evento->whatsappResponsavel, 2)}}</a>
                                    </li>
                                    <li>
                                        <i class="la la-globe"></i>
                                        <a  href="mailto:{{$evento->emailResponsavel}}">{{$evento->emailResponsavel}}</a>
                                    </li>

                                </ul>
                            </div><!-- .place__box -->
                            <div class="place__box place__box-open">
                                <h3 class="place__title--additional">
                                    Horários do Evento
                                </h3>
                                <table class="open-table">
                                    <tbody>
                                    <tr>
                                        <td class="day">Inicio</td>
                                        <td class="time">{{$evento->datainicio->format('d/m/Y H:i')}}</td>
                                    </tr>
                                    <tr>
                                        <td class="day">Fim</td>
                                        <td class="time">{{$evento->datafim->format('d/m/Y H:i')}}</td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div><!-- .place__box -->
                            <div class="place__box">
                                <h3>Perguntas Frequentes</h3>
                                <ul class="faqs-accordion">
                                    <li>
                                        <h4>Quais os métodos de pagamento o site aceita?</h4>
                                        <div class="desc"><p>PIX, Boleto Bancário e Cartão de Crédito em até 6x.</p></div>
                                    </li>
                                    <li>
                                        <h4>Posso trocar a titularidade após a compra?</h4>
                                        <div class="desc"><p>Sim, atráves do nosso suporte via WhatsApp.</p></div>
                                    </li>
                                    <li>
                                        <h4>Como vou receber meu ingresso?</h4>
                                        <div class="desc"><p>Após confirmação do pagamento, <a href="{{route('clientes.minhascompras')}}"> clique aqui </a> e visualize seu ingresso.</p></div>
                                    </li>
                                </ul>
                            </div><!-- .place__box -->

                        </div><!-- .place__left -->
                    </div>
                    <div class="col-lg-4">
                        <div class="sidebar sidebar--shop sidebar--border">
                            <div class="widget-reservation-mini">
                                <h3>Precisa de Ingresso?</h3>
                                <a href="#" class="open-wg btn" style="background-color: #8ac128!important">Compre Aqui</a>
                            </div>
                            <aside class="widget widget-shadow widget-reservation">
                                <h3>Comprar Ingresso</h3>
                                <form action="{{route('site.checkout')}}" method="GET" class="form-underline">
                                    <input type="hidden" name="idEvento" value="<?php echo $evento->id;?>">
                                    <p><b>Selecione o tipo de ingresso:</b></p><br/>

                                    <select class="form-select" name="tipodoingresso" required aria-label="Default select example">

                                        @foreach($ingressos as $i)

                                            @php $quaIngressoVendido = \App\Models\Titulares::where('idevento',$evento->id)->where('tipoingresso',$i->nome)->where('status','confirmado')->count();  @endphp

                                            @if($i->quantidadeMaxima >= $quaIngressoVendido or $i->quantidadeMaxima == 0)

                                                @if($i->dataLimite == null)
                                                    <option value="{{$i->id}}">{{$i->nome}} - R${{$i->valor}}</option>
                                                @else

                                                    @if($i->dataLimite->getTimestamp() >= \Carbon\Carbon::now()->timestamp )
                                                        <option value="{{$i->id}}">{{$i->nome}} - R${{$i->valor}}</option>
                                                    @endif

                                                @endif



                                            @endif
                                        @endforeach
                                    </select>
                                    <br/>
                                    <p><b>Selecione a quantidade:</b></p><br/>
                                    <select class="form-select" name="quantidade" required aria-label="Default select example">
                                        <option value="1">1</option>
                                        <option value="2">2</option>
                                        <option value="3">3</option>
                                        <option value="4">4</option>
                                        <option value="5">5</option>
                                        <option value="6">6</option>
                                        <option value="7">7</option>
                                        <option value="8">8</option>
                                        <option value="9">9</option>
                                        <option value="10">10</option>
                                    </select>

                                    <br/>

                                    <input type="submit"  >
                                    <br/><br/>
{{--                                    <img src="https://pleno.com.vc/plataforma/bandeiras.png"/>--}}
                                </form>
                            </aside><!-- .widget-reservation -->
                        </div><!-- .sidebar -->
                    </div>
                </div>
            </div>
        </div><!-- .place -->

    </main><!-- .site-main -->



@endsection

@section('script')

@endsection

