
<!DOCTYPE html>

<html lang="pt-BR" >


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <title>Congonhas | Painel Prefeitura de congonhas</title>
    <meta charset="utf-8"/>
    <meta name="description" content=""/>
    <meta name="keywords" content=""/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="pt_BR" />
    <meta property="og:type" content="article" />
    <meta property="og:title" content="Congonhas | Painel Prefeitura de congonhas" />
    <meta property="og:url" content="https://admin.congonhas.mg.gov.br"/>
    <meta property="og:site_name" content="Congonhas | Painel Prefeitura de congonhas" />
    <link rel="canonical" href="https://admin.congonhas.mg.gov.br"/>
    <link rel="shortcut icon" href="{{asset('images/brasao_icone.png')}}"/>

    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>        <!--end::Fonts-->



    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="{{asset('admin/assets/plugins/global/plugins.bundle.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('admin/assets/css/style.bundle.css')}}" rel="stylesheet" type="text/css"/>
    <!--end::Global Stylesheets Bundle-->


</head>
<!--end::Head-->

<!--begin::Body-->
<body  id="kt_body"  class="app-blank" >
<script>
    var defaultThemeMode = "light";
    var themeMode;

    if ( document.documentElement ) {
        if ( document.documentElement.hasAttribute("data-bs-theme-mode")) {
            themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
        } else {
            if ( localStorage.getItem("data-bs-theme") !== null ) {
                themeMode = localStorage.getItem("data-bs-theme");
            } else {
                themeMode = defaultThemeMode;
            }
        }

        if (themeMode === "system") {
            themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
        }

        document.documentElement.setAttribute("data-bs-theme", themeMode);
    }
</script>
<!--end::Theme mode setup on page load-->
<!--Begin::Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5FS8GGP" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!--End::Google Tag Manager (noscript) -->

<!--begin::Root-->
<div class="d-flex flex-column flex-root" id="kt_app_root">

    <!--begin::Authentication - Sign-in -->
    <div class="d-flex flex-column flex-lg-row flex-column-fluid">
        <!--begin::Body-->
        <div class="d-flex flex-column flex-lg-row-fluid w-lg-50 p-10 order-2 order-lg-1">
            <!--begin::Form-->
            <div class="d-flex flex-center flex-column flex-lg-row-fluid">
                @if (isset($errors) && count($errors) > 0)
                    <div class="alert alert-danger">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <strong>Erros encontrados!</strong>
                        <ul>
                            @foreach($errors->all() as $error)
                                <li>{{$error}}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                @if (session('success'))

                    <div class="alert alert-success" style="background-color: #d1e7dd; border-color: #badbcc; color: #0f5132; padding: 10px;">

                        {{ session('success') }}
                    </div>

                @endif
                @if (session('erro'))

                    <div class="alert alert-danger" style="padding: 20px;">
                        {{ session('erro') }}
                    </div>

                @endif
                <!--begin::Wrapper-->
                <div class="w-lg-500px p-10">

                    <!--begin::Form-->
                    <form class="form w-100"  id="kt_sign_in_form" data-kt-redirect-url="{{route('admin.login')}}" method="POST" action="{{ route('admin.logar') }}">
                        @csrf
                        <!--begin::Heading-->
                        <div class="text-center mb-11">
                            <!--begin::Title-->
                            <img src="{{asset('/images/octosales-preta.png')}}" style="max-width: 350px" />
                            <!--end::Title-->

                            <!--begin::Subtitle-->
                            <!--end::Subtitle--->
                        </div>
                        <!--begin::Heading-->



                        <!--begin::Separator-->
                        <div class="separator separator-content my-14">
                            <span class="w-125px text-gray-500 fw-semibold fs-7">Bem-vindo(a)</span>
                        </div>
                        <!--end::Separator-->

                        <!--begin::Input group--->
                        <div class="fv-row mb-8">
                            <!--begin::Email-->
                            <input type="email" placeholder="E-mail" name="email" required autocomplete="off" class="form-control bg-transparent"/>
                            <!--end::Email-->
                        </div>

                        <!--end::Input group--->
                        <div class="fv-row mb-3">
                            <!--begin::Password-->
                            <input type="password" placeholder="Senha" name="password" required autocomplete="off" class="form-control bg-transparent"/>
                            <!--end::Password-->
                        </div>
                        <!--end::Input group--->

                        <!--begin::Wrapper-->
                        <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">
                            <div></div>

                            <!--begin::Link-->

                        </div>
                        <!--end::Wrapper-->

                        <!--begin::Submit button-->
                        <div class="d-grid mb-10">
                            <button type="submit" id="kt_sign_in_submit" class="btn btn-primary">

                                <!--begin::Indicator label-->
                                <span class="indicator-label">
    Entrar</span>
                                <!--end::Indicator label-->

                                <!--begin::Indicator progress-->
                                <span class="indicator-progress">
    Aguarde..    <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
</span>
                                <!--end::Indicator progress-->        </button>
                        </div>
                        <!--end::Submit button-->


                        <!--end::Sign up-->
                    </form>
                    <!--end::Form-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--end::Form-->



        </div>
        <!--end::Body-->

        <!--begin::Aside-->
        <div class="d-flex flex-lg-row-fluid w-lg-50 bgi-size-cover bgi-position-center order-1 order-lg-2" style="background-image: url({{asset('admin/bg-login.jpg')}})">
            <!--begin::Content-->
            <div class="d-flex flex-column flex-center py-7 py-lg-15 px-5 px-md-15 w-100">
                <!--begin::Logo-->
                <a href="{{route('admin.login')}}" class="mb-0 mb-lg-12">
                    <img alt="Logo" src="{{asset('images/octosales-branca.png')}}" class="h-60px h-lg-75px"/>
                </a>
                <!--end::Logo-->

                <!--begin::Image-->

                <!--end::Image-->




                <!--end::Text-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Aside-->
    </div>
    <!--end::Authentication - Sign-in-->



</div>
<!--end::Root-->

<!--begin::Javascript-->
<script>
    var hostUrl = "assets/index.html";        </script>

<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<script src="{{asset('admin/assets/plugins/global/plugins.bundle.js')}}"></script>
<script src="{{asset('admin/assets/js/scripts.bundle.js')}}"></script>
<!--end::Global Javascript Bundle-->


<!--begin::Custom Javascript(used for this page only)-->
{{--<script src="{{asset('admin/assets/js/custom/authentication/sign-in/general.js')}}"></script>--}}
<!--end::Custom Javascript-->
<!--end::Javascript-->

</body>
<!--end::Body-->

</html>

