<?php
namespace App\Models;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
class Admin extends Authenticatable
{
    use Notifiable;
    protected $guard = 'admin';
    protected $table = 'admins';
    protected $fillable = [
        'name',
        'email',
        'password',
        'remember_token',
        'avatar',
        'status', // Ativo // Inativo
        'role'   // Admin // Publicador Master // Publicador Simples
    ];
    protected $hidden = [
        'password',
    ];


    public function serializeDate($date): ?string
    {
        return ($date != null) ?  $date->format('Y-m-d H:i:s') : null;
    }
}



