<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;



    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = 'adm/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function logout(Request $request) {

        if(isset($request->erro)){
            Auth::logout();
            return redirect('login')->with('erro', ' Não tem Permissão !!');
        }

        Auth::logout();
        return redirect('login');
    }

    protected function sendLoginResponse(Request $request)
    {

        $request->session()->regenerate();

        $this->clearLoginAttempts($request);

        if($this->guard()->user()->role == 'Admin'){
            return redirect(route('home'));
        }else{

            return redirect(route('sair',['erro'=>'1']));
        }


    }

        public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
}
