<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class ForgotPasswordController extends Controller
{
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function showForgetPasswordForm()
    {
        return view('auth.passwords.email');
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function submitForgetPasswordForm(Request $request)
    {
        $mensagens = [
            'email.exists' => 'Esse email não existe em nosso banco de dados!'
        ];
        $request->validate([
            'email' => 'required|email|exists:clientes',
        ],$mensagens);

        $token = Str::random(64);

        DB::table('password_resets')->insert([
            'email' => $request->email,
            'token' => $token,
            'created_at' => Carbon::now()
        ]);

        $texto = 'Clique no link abaixo para redefinir sua senha.';
        $title = 'Redefinir senha '.env('APP_NAME');
        $url = route('reset.password.get',$token);
        $textobotao = 'Clique para redefinir';

        (New  \App\Models\Funcoes())->enviarEmail($request->email,$title,$texto,$url,$textobotao);


        return back()->with('success', 'Foi enviado um link de redefinir senha para seu email!');
    }
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function showResetPasswordForm($token) {
        $updatePassword = DB::table('password_resets')
            ->where([
                'token' => $token
            ])
            ->first();

        if(!$updatePassword){

            return redirect()->route('forget.password.get')->with('erro', 'token Invalido!');
        }

        return view('auth.passwords.reset', ['token' => $token]);
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function submitResetPasswordForm(Request $request)
    {

        $mensagens = [
            'email.exists' => 'Esse email não existe em nosso banco de dados!'
        ];


        $request->validate([
            'email' => 'required|email|exists:clientes',
            'password' => 'required|string|min:6|confirmed',
            'password_confirmation' => 'required'
        ], $mensagens);

        $updatePassword = DB::table('password_resets')
            ->where([
                'email' => $request->email,
                'token' => $request->token
            ])
            ->first();

        if(!$updatePassword){
            return redirect()->route('forget.password.get')->withInput()->with('erro', 'token Invalido!');
        }

        $user = User::where('email', $request->email)
            ->update(['senha' => Hash::make($request->password)]);

        DB::table('password_resets')->where(['email'=> $request->email])->delete();

        return redirect('/login')->with('success', 'Sua senha foi alterada com sucesso!');
    }
}
