<?php

namespace App\Http\Controllers\Admin;

use App\Models\Admin;
use App\Models\Category;
use App\Models\Noticia;
use App\Models\Servico;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class UsuariosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }




        $categories = Admin::orderby('id','asc')->paginate();
        return view('app.usuarios.index', compact('categories'));
    }

    public function busca(Request $request)
    {
        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }

        $categories = Admin::
            where(
                function ($query) use ($request) {
                    $query->where('created_at', 'LIKE', '%'. $request->buscar .'%')
                        ->orwhere('email', 'LIKE', '%'. $request->buscar .'%')
                        ->orwhere('updated_at', 'LIKE', '%'. $request->buscar .'%')
                        ->orwhere('role', 'LIKE', '%'. $request->buscar .'%')
                        ->orwhere('status', 'LIKE', '%'. $request->buscar .'%')
                        ->orwhere('name', 'LIKE', '%'. $request->buscar .'%');
                }
            )
            ->paginate(50);



        return view('app.usuarios.index', compact('categories','request'));
    }






    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }
        return view('app.usuarios.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }
       $dados = $request->all();

       $dados['password'] = Hash::make($dados['password']);


        Admin::create($dados);
        return redirect()->route('usuarios.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Servico $category
     * @return \Illuminate\Http\Response
     */
    public function show(Admin $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Servico $category
     * @return \Illuminate\Http\Response
     */
    public function edit(  $id)
    {
        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }
        $category = Admin::find($id);


        return view('app.usuarios.edit',compact('category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \App\Models\Servico            $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }


        $category = Admin::find($id);
        $dados = $request->except('password');


        if($request->password){
            $dados['password'] = Hash::make($request->password);
        }


        $category->update($dados);
        return redirect()->route('usuarios.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Admin $category
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {

        $account= auth('admin')->user();
        if($account->role != 'Admin'){
            return redirect()->route('usuarios.index');
        }

        $category = Admin::find($id);

        $category->delete();


        return redirect()->route('usuarios.index');
    }
}
