<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Cupom;
use App\Models\Eventos;
use App\Models\Funcoes;
use App\Models\Ingressos;
use App\Models\Obras;
use App\Models\Titulares;
use App\Models\User;
use App\Models\Vendas;
use Carbon\Carbon;
use http\Env\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Analytics\Facades\Analytics;
use Spatie\Analytics\Period;

class LoginController extends Controller
{
    public function login() {

        return view('admin.login');
    }

    public function logar(Request  $request) {

        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);




       if(!Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password], $request->lembrar ? true : false)){
           return redirect()->route('admin.login')->with('erro','Email ou senha não existe.');
       }

        return redirect()->route('admin.dashboard');

    }

    public function logout() {

        Auth::guard('admin')->logout();
        return redirect()->route('admin.login')
            ->with('success', 'Deslogado com sucesso.');

    }

    public function dashboard(Request $request) {
        return view('admin.painel.dashboard');

            }

}
